{******************************************************************************}
{                                                                              }
{ Excel Interface Component                                                    }
{ Component ExcelUtilities.pas                                                 }
{ This interface component can be downloaded at www.tcoq.org, component page.  }
{                                                                              }
{ The contents of this file are subject to the Mozilla Public License Version  }
{ 1.1 (the "License"); you may not use this file except in compliance with the }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/ }
{                                                                              }
{ Software distributed under the License is distributed on an "AS IS" basis,   }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for }
{ the specific language governing rights and limitations under the License.    }
{                                                                              }
{ The Original Code is TestCaseExcel.pas                                      }
{                                                                              }
{ The Initial Developer of the Original Code is Thierry.Coq                    }
{ thierry.coq(at)centraliens.net                                               }
{ Portions created by this individual are Copyright (C)                        }
{ 2000-2008 of this individual.                                                }
{                                                                              }
{ Last modified: 2008/11/08                                                    }
{ Version 0.1                                                                  }
{                                                                              }
{******************************************************************************}
unit TestCaseExcel;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, fpcunit, testutils, testregistry, ExcelUtilities;

const
  TestFileName = 'c:\Donnees\test.xls';

type

  { TTestCaseExcel }

  TTestCaseExcel= class(TTestCase)
  private
    ExcelApp : TExcelApplication;
    ExcelWbs : TWorkBooks;
    ExcelWb  : TWorkBook;
    ExcelSheets : TSheets;
    aSheet : TSheet;
    aCell : TRange;
  protected
    procedure SetUp; override; 
    procedure TearDown; override; 
  public
  published
    procedure TestHookUp; 
    procedure TestFirstExcelSimpleTest;
    procedure TestFontFormatting;
    procedure TestColumnFormatting;
    procedure TestRowFormatting;
  end; 

implementation

procedure TTestCaseExcel.TestHookUp; 
begin
  AssertTrue('Excel should be visible now!', Assigned( ExcelApp));
end;

procedure TTestCaseExcel.TestFirstExcelSimpleTest;
var
  aValue : OleVariant;
begin

  aCell := aSheet.Cells(1, 1);
  aCell.Value := 10;
  aValue := aCell.Value;
  AssertTrue( 'checking values can be get and set', aValue = 10);

  aCell := aSheet.Cells(2,1);
  aCell.Formula := '=A1+10';
  aValue := aCell.Value;
  AssertTrue( 'checking formulas can be get and set', aValue = 20);

  aCell.Interior.Color := $FF0000; //Blue
  AssertTrue( 'color has been set', aCell.Interior.Color = $FF0000);

  aCell := aSheet.Cells(3,1);
  aCell.Value := '=A2+10';
  ExcelWB.Save;
  AssertTrue('Save has been completed', True);
end;

procedure TTestCaseExcel.TestFontFormatting;
begin
  // FirstExcelSimpleTest shall have been successful, before this one can be.
  // ========================================================================

  // Setting Font to bold.
  aCell := aSheet.Cells(4,1);
  aCell.Value := 'Bold';
  aCell.Font.Bold:= true;
  AssertTrue('Font is bold', aCell.Font.Bold);

  // Setting Font Size.
  aCell := aSheet.Cells(4,1);
  aCell.Value := 'Big Size';
  aCell.Font.Size := 20;
  AssertTrue('Font is bold', aCell.Font.Size = 20);

  // Setting Font Color
  aCell := aSheet.Cells(5,1);
  aCell.Value := 'Color Blue';
  aCell.Font.Color := $FF0000;
  AssertTrue('Font is blue', aCell.Font.Color = $FF0000);


end;

procedure TTestCaseExcel.TestColumnFormatting;
begin
  aCell := aSheet.Cells(1,2);
  aCell.ColumnWidth := 200;
  AssertTrue('Excel workbook can be created', aCell.ColumnWidth = 200);
end;

procedure TTestCaseExcel.TestRowFormatting;
begin
  aCell := aSheet.Cells(1,1);
  aCell.RowHeight := 60;
  AssertTrue('Excel workbook can be created', aCell.RowHeight = 60);
end;


procedure TTestCaseExcel.SetUp; 
begin
  ExcelApp := TExcelApplication.Create(nil);
  ExcelApp.Active := True;
  ExcelApp.Visible := True;
  ExcelWbs := ExcelApp.WorkBooks;

  if FileExists( TestFileName) then
    ExcelWb := ExcelWbs.Open( TestFileName)
  else
  begin
    ExcelWb := ExcelWbs.Add;
    AssertTrue('Excel workbook can be created', Assigned(ExcelWB));
    ExcelWB.SaveAs(TestFileName);
  end;

  ExcelSheets := ExcelWb.Sheets;
  aSheet := ExcelSheets.Sheet('Sheet1');
  AssertTrue('Excel sheet can be retrieved', Assigned(ExcelWB));
end;

procedure TTestCaseExcel.TearDown; 
begin
  ExcelApp.Quit;
  FreeAndNil(ExcelApp);
end;

initialization

  RegisterTest(TTestCaseExcel); 
end.

