{******************************************************************************}
{                                                                              }
{ Diagnostics Utility                                                          }
{ Component Diagnostics.pas                                                    }
{ This interface component can be downloaded at www.tcoq.org, component page.  }
{                                                                              }
{ The contents of this file are subject to the Mozilla Public License Version  }
{ 1.1 (the "License"); you may not use this file except in compliance with the }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/ }
{                                                                              }
{ Software distributed under the License is distributed on an "AS IS" basis,   }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for }
{ the specific language governing rights and limitations under the License.    }
{                                                                              }
{ The Original Code is ExcelUtilities.pas                                      }
{                                                                              }
{ The Initial Developer of the Original Code is Thierry.Coq                    }
{ thierry.coq(at)centraliens.net                                               }
{ Portions created by this individual are Copyright (C)                        }
{ 2000-2008 of this individual.                                                }
{                                                                              }
{ Last modified: 2008/11/08                                                    }
{ Version 0.1                                                                  }
{                                                                              }
{******************************************************************************}
unit Diagnostics;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

procedure logMessage( aMsg : String);


implementation

var
  FDiagnostics: TStrings;
  FActive : Boolean;

procedure logMessage( aMsg : String);
begin
  if FActive then
  FDiagnostics.Add(aMsg);
end;

initialization
  FDiagnostics := TStringList.Create;
  FActive      := False;
finalization
  FDiagnostics.SaveToFile( 'Diagnostics.txt');
  FreeAndNil( FDiagnostics);
end.

